/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;

public class BeamCurtainGraphic
extends PhetShapeGraphic
implements PhotonSource.RateChangeListener,
PhotonSource.WavelengthChangeListener {
    Shape beamArea = new Rectangle();
    private Color actualColor;
    private Beam beam;
    int colorMax = 255;

    public BeamCurtainGraphic(Component component, Beam beam) {
        super(component);
        this.beam = beam;
        beam.addRateChangeListener(this);
        beam.addWavelengthChangeListener(this);
        this.update();
    }

    protected Rectangle determineBounds() {
        return this.beamArea.getBounds();
    }

    private void update() {
        Color color = VisibleColor.wavelengthToColor(this.beam.getWavelength());
        int n = 200;
        int n2 = Math.max(n, this.colorMax - (int)((double)(this.colorMax - n) * Math.pow(this.beam.getPhotonsPerSecond() / this.beam.getMaxPhotonsPerSecond(), 0.3)));
        this.actualColor = this.getActualColor(color, n2);
        this.beamArea = this.beam.getBounds();
        this.setShape(this.beamArea);
        this.setPaint(this.actualColor);
        this.setBoundsDirty();
        this.repaint();
    }

    private Color getActualColor(Color color, int n) {
        double d = MakeDuotoneImageOp.getGrayLevel(color);
        int n2 = MakeDuotoneImageOp.getDuoToneRGB(n, n, n, this.colorMax, d, color);
        return new Color(n2);
    }

    public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
        this.update();
    }

    public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
        this.update();
    }
}

